;	FLAPPY BIRD in only 256 bytes
; 	Coded by Ko-Ko in 2023. e-mail: kolma.kornel@gmail.com
;	Commodore 64 version, there's gonna be at least one more port (to my lovely Commodore Plus /4).
;
; 	If you like it, send me a real postcard just like in the good old days.
; 
; 	NAME:
;	Kornel Kolma (Ko-Ko)
;
; 	ADDRESS:
; 	Frigyes u. 10.
; 	Budapest
; 	H1039
; 	Hungary
;
;	DESCRIPTION:
;	Get ready to flap like a pro with the most compact version of Flappy Bird 
;	for the Commodore 64! With only 256 bytes of pure fun, this mini-game will 
;	challenge your hand-eye coordination to the limit. So put on your retro gaming 
;	hat, avoid pipes, and see how far you can fly in this byte-sized adventure!
;
;	HOW TO LOAD, START AND PLAY:
;	load "flappy256.prg",8,1
;	sys 4096
;	The game starts immediately. 
;	Use the SPACE bar to fly the bird as far as you can.
;	If you hit the pipe, the game is over. 
;	You can start another round with the ENTER key.

!to "flappy256.prg",cbm
*= $1000 					; sys 4096 -> no more bytes left, so you need to 'sysme'

pspc		= $02			;register for the spaces between pipes
prnd 		= $20			;random number 0-7 (upper part of the pipe)
pdif		= $21 			;tunnel size -> space between the upper and lower part of the pipes, this is for leveling also
plev		= $24			;level information (size of the tunel)
keyporta 	= $dc02			;io column
keyportb 	= $dc03			;io raw
keycol 		= $dc00 		;portA -> keyboard matrix column
keyrow 		= $dc01			;portB -> keyboard matrix raw
getin		= $ffe4			;Kernal GETIN
clrscrn		= $e544
hpoint		= $0413			;game point screen locations
lpoint		= $0414
fbird		= $0575			;here is the FB

start:
	jsr clrscrn
	lda #$c5
	sta $0400+119
	sta $0400+919
;	lda #$40				;commented out for shortening the code, another 8 bytes to dust		
;	sta $0400+79
;	sta $0400+959
	
	lda #$30			
	sta hpoint				;for counting points
	sta lpoint
	sta $d021

	lda #$07				;space beetween upper and lower part of the pipe, start with a larger number
	sta pdif	
	sta prnd				;random number for the pipes, start with 07
	sta plev				;also need to reset leveling
	
	lda #<fbird				;FB loc.
	sta $54
	lda #>fbird
	sta $55
	sta pspc				;first pipe after 05 characters
			
gameloop:
	ldy #$01
	lda #$69				;draw that well detailed flappy bird :-)
	sta ($54),y

	jsr wait
	jsr screenScrol
	
	ldy #$01				;very simple collision detection
	lda ($54),y
	cmp #$20
	beq nocollusion
waitforenter:				;end of game wait for the user to hit Enter
	jsr getin
	cmp #$0d
	bne waitforenter
	beq start				;this was a JMP but its one byte shorter
nocollusion:
	dey
	lda #$20				;delete bird -> this also cause flappy effect
	sta ($54),y
							;kernal keyboard routine was to slowish here
	; lda #$0				;it seems that it doesn't need to set this up so we can save 10 more bytes 
	; sta keyportb			;setting up i/O ports
	; lda #$ff
	; sta keyporta		
	lda #%01111111  		;Welcome Neo! Your task is to find the Space key in the Matrix.
	sta keycol				
	lda keyrow      		
	and #%00010000  		;
	bne birddown
	sec						;Space is pressed so the bird is going up
	lda $54
	sbc #40
	sta $54
	bcs birdupnocc
	dec $55
birdupnocc:
	jmp gameloop
birddown:
	clc						;if not up then down
	lda $54
	adc #40
	sta $54
	bcc birddownnocc
	inc $55
birddownnocc:
	jmp gameloop

;***************************MAIN GAME LOGIC START ***********************************
screenScrol:
	lda #80					;INIT screenscroll, start at $0400 + 2*40
	sta $fb
	sta $fd
	inc $fb
	lda #04					;there are many register where we need to start with the value 04
	sta $fc
	sta $fe
	sta $23					;for pipe => see the high byte later
	
	ldx #$15				;number of lines to scroll
copyxrow:
	ldy #$00
copyonerow:
	lda ($fb),y
	sta ($fd),y
	iny
	cpy #39
	bne copyonerow
	clc
	lda $fd
	adc #40
	sta $fd
	sta $fb
	lda $fc
	adc #$00
	sta $fc
	sta $fe
	inc $fb
	dex
	bne copyxrow
	
	dec pspc
	beq makepipe
wait:						;whatever, just wait, can anybody do it shorter?
	cmp $d012
	bne wait
	rts

makepipe:

	inc lpoint				;counting points and making the game harder
	lda lpoint
	cmp #$3A				;is it more than '9'
	bne nonine
	lda #$30				;reset low point to '0'
	sta lpoint
	inc hpoint				
	dec plev				;next level (narrow down the tunnel with one char)
nonine:
	ldx #119				;pipe start at $0400 + 159
	stx $22
	ldx #$13				;so let's draw a pipe
drawpipe:
	lda prnd				;this random number sets the length of the upper part of the pipe 
	cmp #$00
	beq middlepipe
	dec prnd
	lda #$dd				;i think this one is the nicest char for a pipe possible
	sta ($22),y
	jmp stillmiddle
middlepipe:
	dec pdif				;making the "middle" of the pipe (a.k.a. the tunnel)
	bne stillmiddle
	dec prnd				;after the tunnel ready, we need to make sure that drawpipe runs again for the lower part
stillmiddle:
	clc
	lda $22
	adc #40
	sta $22
	lda $23
	adc #00
	sta $23
	dex
	bne drawpipe
	lda $dc04				;a 5 byte "random" number generator for the pipes / tunnels
	and #%00000111
	sta prnd
	
	lda #$15				;distance between pipes
	sta pspc	

	lda plev				;current level => tunnel size => spaces beetween upper and lower part of the pipe
	sta pdif
	rts